<?php $this->load->view("templates/common/top_section"); ?>
<style type="text/css">
    @media print {

        .no-print,
        #breadcrumbs {
            display: none;
        }

        #emp-view {
            display: block !important;
        }

        table td {
            padding: 2px !important;
        }
    }
</style>

<div class="row">
        <div class="col-md-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Monthly Pay Apply</h5>
                </div>
                <div class="card-body">

                    <div class="">
                    <form method="post" action="<?= base_url('attendance/transferred_attendance'); ?>"
                            class="form-search">
                    <div class="row mb-3 g-3">
                                    <div class="col-12 col-sm-4">
                                        <input type="text" placeholder="Month" name="month" id="month"
                                            <?= (isset($month)) ? 'value="' . $month . '"' : date('Y-m'); ?>
                                            data-date-format="yyyy-mm" readonly class="form-control datfe-picker">
                                    </div>

                                    <div class="col-12 col-sm-4">
                                        <select id="EmpNo" name="EmpNo" class="select2 form-select form-control">
                                            <option value="">--Select Employee--</option>
                                            <?php
                                            $emp = '';
                                            if (is_array($employees)) {
                                                foreach ($employees as $epm):
                                                    $ck = '';
                                                    if (isset($EmpNo) and !empty($EmpNo) and $EmpNo == $epm->EId) {
                                                        $ck = 'selected';
                                                        $emp = '<p id="emp-view" style="display:none;">' . $epm->EmpNo . ' - ' . $epm->EmpName . '</p>';
                                                    }
                                                    echo '<option ' . $ck . ' value="' . $epm->EId . '">' . $epm->EmpNo . ' - ' . $epm->EmpName . '</option>';
                                                endforeach;
                                            }
                                            ?>
                                        </select>
                                    </div>

                                    <div class="col-12 col-sm-3">
                                        <button class="btn btn-primary"><i class="bx bx-check me-2"></i>Search</button>
                                    </div>
                                </div>

                    </form> 
                    </div>
                </div>


            </div>

        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Attandance List</h5>
                </div>
                <div class="card-body">

                <table class="table table-striped table-bordered table-hover">
                        <thead>
                            <tr role="row">
                                <th>#</th>
                                <th>In Date</th>
                                <th>In Time</th>
                                <th>Out Date</th>
                                <th>Out Time</th>
                                <th>OT</th>
                                <th>DOT</th>
                                <th>TOT</th>
                            </tr>
                        </thead>
                        <tbody role="alert" aria-live="polite" aria-relevant="all">
                            <?php
                            if (isset($completed_attendance) and !empty($completed_attendance)) {
                                $total_ot = 0;
                                $total_dot = 0;
                                $total_tot = 0;
                                $i = 1;
                                foreach ($completed_attendance as $row):
                                    $total_ot = $total_ot + $row->OT;
                                    //$total_ot = $total_ot+$this->attn->convertSeconds($row->OT, '.');
                                    $total_dot = $total_dot + $row->DOT;
                                    $total_tot = $total_tot + $row->TOT;
                                    //$total_dot = $total_dot+$this->attn->convertSeconds($row->DOT, '.');
                            
                                    ?>
                                    <tr role="row">
                                        <td>
                                            <?= $i; ?>
                                        </td>
                                        <td><?= $row->DATE; ?></td>
                                        <td><?= $row->INTIME; ?></td>
                                        <td><?= $row->OUTDATE; ?></td>
                                        <td><?= $row->OUTTIME; ?></td>
                                        <td><?= $this->attn->convertSeconds($row->OT, '.'); ?></td>
                                        <td><?= $this->attn->convertSeconds($row->DOT, '.'); ?></td>
                                        <td><?= $this->attn->convertSeconds($row->TOT, '.'); ?></td>
                                    </tr>

                                    <?php
                                    $i++;
                                endforeach;
                                ?>
                                <tr>
                                    <td colspan="5" style="text-align: right">Total</td>
                                    <td><?= number_format($this->attn->convertSeconds($total_ot, '.'), 2); ?></td>
                                    <td><?= number_format($this->attn->convertSeconds($total_dot, '.'), 2); ?></td>
                                    <td><?= number_format($this->attn->convertSeconds($total_tot, '.'), 2); ?></td>
                                </tr>
                                <?php
                            }
                            ?>
                        </tbody>
                    </table>
                </div>


            </div>

        </div>
    </div>


<?php $this->load->view("templates/common/footer"); ?>