<?php $this->load->view("templates/common/top_section"); ?>
<!-- Icons. Uncomment required icon fonts -->
<link rel="stylesheet" href="<?php echo asset_url(); ?>assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
<link rel="stylesheet"
    href="<?php echo asset_url(); ?>assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
<!-- /section:basics/content.breadcrumbs -->
<!-- Basic Layout & Basic with Icons -->
<div class="row">
    <div class="col-md-5">
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Apply Leave</h5>
            </div>
            <div class="card-body">


                <form class="form-horizontal needs-validation" novalidate
                    action="<?php echo base_url('leave_transaction/edit_year'); ?>" method="post" role="form">

                    <div class="mb-3">
                        <label class="form-label" for="EmpNo">Employee</label>
                        <select id="EmpNo" class="select2 form-select form-control" required name="EmpNo">
                            <option value="">--Select Employee --</option>
                            <?php
                            foreach ($employees as $emp) {
                                $select = (isset($e) and $e == $emp->EId) ? 'selected="selected"' : null;
                                echo '<option ' . $select . ' value="' . $emp->EId . '">' . trim($emp->EmpName) . ' -- ' . $emp->EmpNo . '</option>';
                            }
                            ?>
                        </select>
                        <div class="invalid-feedback">
                            Employee is required.
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="name">Leave Code</label>
                        <select required class="chosen-select form-control" name="Leave_Code" id="Leave_Code">
                            <option value="">Leave Code</option>
                            <?php
                            if (is_array($LeaveCodes)) {
                                foreach ($LeaveCodes as $code) {
                                    echo '<option ' . $select . ' value="' . $code->Leave_code . '">' . trim($code->Description) . '</option>';
                                }
                            }
                            ?>
                        </select>
                        <div class="invalid-feedback">
                            Leave is required.
                        </div>
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="Term">Num of Days:</label>
                        <input type="text" class="form-control" name="Days" id="Days" readonly />

                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="Term">Balance</label>
                        <input type="text" class="form-control" name="Balance" id="Balance"  />

                    </div>
                    <button type="submit" class="btn btn-primary">Add</button>
                </form>
            </div>
        </div>


    </div>



    <div class="col-md-7">
        <div class="row">
            <div class="col-md-12 mb-4">
                <!-- Basic Bootstrap Table -->
                <div class="card">
                    <h5 class="card-header">Year Leave Balance </h5>
                    <div class="card-datatable text-nowrap">
                    <table id="leave-balance" class="table table-striped table-bordered table-hover">
                                    <thead>
                                    <tr>
                                        <th>Leave Code</th>
                                        <th>Description</th>
                                        <th>Days</th>
                                        <th>Balance</th>
                                    </tr>
                                    </thead>
                                </table>
                        
                    </div>
                </div>
            </div>
            <!--/ Basic Bootstrap Table -->

          
        </div>
    </div>



</div>

<?php $this->load->view("templates/common/footer"); ?>