<?php
require_once("Main_model.php");

class monthItem_model extends Main_model
{
    private $tableName = 'trans';
    private $join = 'employee';

    public function _construct()
    {
        //$this->load->database();
    }

    /*
    Determines if a given string is an exists
    */
    function exists($var)
    {
        if ($var) {
            return true;
        } else {
            return false;
        }
    }

    function get_over_times($month=null,$code=array(),$all=1,$employees=array())
    {
        $return = array();
        $holidays = $this->get_holidays($month);
        if($all==1)
        {
            $eml = $employees;
            $shift = $this->get_user_shift($eml);
            /*$this->attn->p($shift);
            die();*/
            $r = array();
            if($shift)
            {
                $time1 = new DateTime($shift->Shift_From);
                $time2 = new DateTime($shift->Shift_To);
                $hours = $this->attn->DateIntervalToSec($time2, $time1);
                /*$comtabel = 60*60;*/

                //$late_time = ($shift->Shift_To == '00:00:00') ? '16:00:00': $shift->Shift_To;
                $late_time = date('H:i:s', strtotime($shift->Shift_To . " +8 hours"));
                //echo $late_time; die();
                $attns = $this->get_all_attn_filter($eml,$month);
                $day_second = 8*60*60;
                $night_day_second = 4*60*60;
                $saturday_night_day_second = 7*60*60;
                $saturday_second = 5*60*60;
                $saturday_ot_second = 3*60*60;
                $hours_second = 1*60*60;

                $s=1;
                foreach($attns as $a)
                {
                    $ot_hours = 0; //second
                    $dot_hours = 0; //second
                    $in_date_seconds = ($a->OTDiffInDay+1);
                    $out_date_seconds = $a->OTDiffOutDay;
                    $normal_in_date_seconds = $a->diff;
                    $normal_in_date_seconds_day = $a->DayShift;

                    if(in_array("NOT", $code))
                    {
                        if($hours==0)
                        {

                                if($a->OUTDATE !='0000-00-00')
                                {
                                    $in_month = date('Y-m',strtotime($a->DATE));
                                    $out_month = date('Y-m',strtotime($a->OUTDATE));
                                    /*
                                    to check in date and out date month in same month
                                    example in date 2017-06 and out date 2017-07
                                   */
                                    if($in_month==$out_month){

                                        if(strtotime($a->INTIME) >= strtotime($late_time))
                                        {
                                            if ((!in_array($a->outd, $holidays) and $a->outweekday!=6) and $a->outweekday!=5)
                                            {
                                                $total_work_seconds = $out_date_seconds + $in_date_seconds;
                                                if ($total_work_seconds >= $day_second)
                                                {
                                                    $day_diff = ($total_work_seconds - $day_second);
                                                    $day_diff = ($day_diff > $night_day_second)?$night_day_second:$day_diff;
                                                    $ot_hours = $ot_hours + $day_diff;
                                                }
                                            }

                                            else if((!in_array($a->outd, $holidays) and $a->outweekday!=6) and $a->outweekday==5)
                                            {
                                                $total_work_seconds = $out_date_seconds + $in_date_seconds;
                                                if ($total_work_seconds >= $saturday_second)
                                                {
                                                    $day_diff = ($total_work_seconds - $saturday_second);
                                                    $day_diff = ($day_diff > $saturday_night_day_second)?$saturday_night_day_second:$day_diff;
                                                    $ot_hours = $ot_hours + $day_diff;
                                                }
                                            }
                                        }
                                        else
                                        {


                                            /*when IN day not in holiday, OUT day not in holiday, IN day not saturday, OUT day not saturday
                                            1 1 1 1 = 8 0 => 8 */
                                            if (!in_array($a->ind, $holidays) and !in_array($a->outd, $holidays) and $a->weekday!=5 and $a->outweekday!=5)
                                            {
                                                //echo $a->DATE.'<br/>';
                                                if ($in_date_seconds > $day_second)
                                                {
                                                    $day_diff = ($in_date_seconds - $day_second);
                                                    if($a->ind==$a->outd){
                                                        $day_diff = ($in_date_seconds - $normal_in_date_seconds);
                                                    }else{
                                                        $day_diff = ($day_diff > $day_second)?$day_second:$day_diff;
                                                    }

                                                    //$day_diff = ($day_diff > $day_second)?$day_second:$day_diff;
                                                    $ot_hours = $ot_hours + $day_diff;
                                                }
                                            }
                                            /*when IN day not in holiday, OUT day not in holiday, IN day not saturday, OUT day saturday
                                            1 1 1 0 = 8 3 => 11 */
                                            else if(!in_array($a->ind, $holidays) and !in_array($a->outd, $holidays) and $a->weekday!=5 and $a->outweekday==5)
                                            {
                                                if ($in_date_seconds > $day_second)
                                                {
                                                    $day_diff = ($in_date_seconds - $day_second);
                                                    //$day_diff = ($day_diff > $day_second)?$day_second:$day_diff;
                                                    if($a->ind==$a->outd){
                                                        $day_diff = ($in_date_seconds - $normal_in_date_seconds);
                                                    }else{
                                                        $day_diff = ($day_diff > $day_second)?$day_second:$day_diff;
                                                    }
                                                    $ot_hours = $ot_hours + $day_diff;
                                                    /*if ($day_diff > $hours_second)
                                                    {
                                                        $ot_hours = $ot_hours + $day_diff;
                                                    }*/
                                                }

                                                if ($out_date_seconds > $saturday_second)
                                                {
                                                    $day_diff = ($out_date_seconds - $saturday_second);
                                                    $day_dff = ($day_diff > 3*60*60)?3*60*60:$day_diff;
                                                    $ot_hours = $ot_hours + $day_dff;
                                                    /*if ($day_diff > $hours_second)
                                                    {
                                                    $day_dff = (floor($day_diff / 3600)> 3)?3:floor($day_diff / 3600);
                                                    $ot_hours = $ot_hours + $day_dff;
                                                    }
                                                    */

                                                }

                                            }
                                            /*when IN day not in holiday, OUT day not in holiday, IN day saturday, OUT day not saturday
                                            1 1 0 1 = 11 0 => 11*/
                                            else if(!in_array($a->ind, $holidays) and !in_array($a->outd, $holidays) and $a->weekday==5 and $a->outweekday!=5)
                                            {

                                                if ($in_date_seconds > $saturday_second)
                                                {
                                                    $day_diff = ($in_date_seconds - $saturday_second);
                                                    $day_diff = ($day_diff > 11*60*60)?11*60*60:$day_diff;
                                                    $ot_hours = $ot_hours + $day_diff;
                                                    /*if ($day_diff > $hours_second)
                                                    {
                                                        $ot_hours = $ot_hours + $day_diff;
                                                    }*/
                                                }
                                            }

                                            /*when IN day in holiday, OUT day not in holiday, IN day not saturday, OUT day not saturday
                                            0 1 0 0 = 0 0 => 0

                                            //this condition does not apply for Normal OT, goes duble OT
                                            else if(in_array($a->ind, $holidays) and !in_array($a->outd, $holidays) and $a->weekday!=5 and $a->outweekday!=5)
                                            {

                                                if ($in_date_seconds > $day_second)
                                                {
                                                    $day_diff = ($in_date_seconds - $day_second);
                                                    $day_diff = ($day_diff > $day_second)?$day_second:$day_diff;
                                                    $ot_hours = $ot_hours + $day_diff;

                                                }
                                            }
                                            */

                                            /*when IN day in holiday, OUT day not in holiday, IN day saturday, OUT day not saturday
                                            0 1 0 1 = 11 0 => 11
                                            //this condition does not apply for Normal OT, goes duble OT
                                            else if(in_array($a->ind, $holidays) and !in_array($a->outd, $holidays) and $a->weekday==5 and $a->outweekday!=5)
                                            {

                                                if ($in_date_seconds > $day_second)
                                                {
                                                    $day_diff = ($in_date_seconds - $day_second);
                                                    $day_diff = ($day_diff > $day_second)?$day_second:$day_diff;
                                                    $ot_hours = $ot_hours + $day_diff;
                                                }
                                            }
                                            */

                                            /*when IN day in holiday, OUT day not in holiday, IN day not saturday, OUT day saturday
                                            0 1 1 0 = 0 3 => 3 */

                                            else if(in_array($a->ind, $holidays) and !in_array($a->outd, $holidays) and $a->weekday!=5 and $a->outweekday==5)
                                            {
                                                if ($out_date_seconds > $saturday_second)
                                                {
                                                    $day_diff = ($out_date_seconds - $saturday_second);
                                                    $day_dff = ($day_diff > 3*60*60)?3*60*60:$day_diff;
                                                    $ot_hours = $ot_hours + $day_dff;
                                                    /*if ($day_diff > $hours_second)
                                                    {
                                                    $day_dff = (floor($day_diff / 3600)> 3)?3:floor($day_diff / 3600);
                                                    $ot_hours = $ot_hours + $day_dff;
                                                    }
                                                    */
                                                }
                                            }

                                            /*when IN day not in holiday, OUT day in holiday, IN day not saturday, OUT day not saturday
                                            1 0 1 1 = 8 0 => 0*/
                                            else if(!in_array($a->ind, $holidays) and in_array($a->outd, $holidays) and $a->weekday!=5 and $a->outweekday!=5)
                                            {
                                                if ($in_date_seconds > $day_second)
                                                {
                                                    $day_diff = ($in_date_seconds - $day_second);
                                                    //$day_diff = ($day_diff > $day_second)?$day_second:$day_diff;
                                                    if($a->ind==$a->outd){
                                                        $day_diff = ($in_date_seconds - $normal_in_date_seconds);
                                                    }else{
                                                        $day_diff = ($day_diff > $day_second)?$day_second:$day_diff;
                                                    }
                                                    $ot_hours = $ot_hours + $day_diff;
                                                    /*if ($day_diff > $hours_second)
                                                    {
                                                        $ot_hours = $ot_hours + $day_diff;
                                                    }*/
                                                }
                                            }

                                            /*when IN day not in holiday, OUT day in holiday, IN day saturday, OUT day not saturday
                                            1 0 0 1 = 11 0 => 0*/
                                            else if(!in_array($a->ind, $holidays) and in_array($a->outd, $holidays) and $a->weekday==5 and $a->outweekday!=5)
                                            {
                                                if ($in_date_seconds > $saturday_second)
                                                {
                                                    $day_diff = ($in_date_seconds - $saturday_second);

                                                    $day_diff = ($day_diff > 11*60*60)?11*60*60:$day_diff;

                                                    $ot_hours = $ot_hours + $day_diff;
                                                    /*if ($day_diff > $hours_second)
                                                    {
                                                        $ot_hours = $ot_hours + $day_diff;
                                                    }*/
                                                }
                                            }


                                            /*when IN day not in holiday, OUT day in holiday, IN day not saturday, OUT day saturday
                                            1 0 1 0 = 0 0 => 0
                                            //this condition does not apply Normal OT
                                            else if(!in_array($a->ind, $holidays) and in_array($a->outd, $holidays) and $a->weekday!=5 and $a->outweekday==5)
                                            {
                                                if ($in_date_seconds > $saturday_second) {
                                                    $day_diff = ($in_date_seconds - $saturday_second);
                                                    $day_diff = ($day_diff > 11*60*60)?11*60*60:$day_diff;
                                                    $ot_hours = $ot_hours + $day_diff;

                                                }
                                            }
                                            */
                                        }

                                    }
                                    else
                                    {
                                        if(strtotime($in_month) < strtotime($month))
                                        {

                                            if(strtotime($a->INTIME) >= strtotime($late_time))
                                            {
                                                if ((!in_array($a->outd, $holidays) and $a->outweekday!=6) and $a->outweekday!=5)
                                                {
                                                    $total_work_seconds = $out_date_seconds + $in_date_seconds;
                                                    if ($total_work_seconds >= $day_second)
                                                    {
                                                        $day_diff = ($total_work_seconds - $day_second);
                                                        $day_diff = ($day_diff > $night_day_second)?$night_day_second:$day_diff;
                                                        $ot_hours = $ot_hours + $day_diff;
                                                    }
                                                }

                                                else if((!in_array($a->outd, $holidays) and $a->outweekday!=6) and $a->outweekday==5)
                                                {
                                                    $total_work_seconds = $out_date_seconds + $in_date_seconds;
                                                    if ($total_work_seconds >= $saturday_second)
                                                    {
                                                        $day_diff = ($total_work_seconds - $saturday_second);
                                                        $day_diff = ($day_diff > $saturday_night_day_second)?$saturday_night_day_second:$day_diff;
                                                        $ot_hours = $ot_hours + $day_diff;
                                                    }
                                                }
                                            }
                                            else
                                            {
                                                /*
                                            * when OUT day not in holiday, OUT day not sunday, OUT day not saturday
                                            * there are no NOT hours in this
                                            */

                                                /* if ((!in_array($a->outd, $holidays) and $a->outweekday!=6) and $a->outweekday!=5)
                                                 {

                                                 }*/

                                                /*
                                                 * when OUT day not in holiday, OUT day not sunday, OUT day saturday */
                                                if ((!in_array($a->outd, $holidays) and $a->outweekday!=6) and $a->outweekday==5)
                                                {
                                                    if ($out_date_seconds > $saturday_second)
                                                    {
                                                        $day_diff = ($out_date_seconds - $saturday_second);
                                                        $day_dff = ($day_diff > 3*60*60)?3*60*60:$day_diff;
                                                        $ot_hours = $ot_hours + $day_dff;
                                                    }
                                                }

                                            }
                                        }
                                        else
                                        {
                                            /*
                                            * when IN day not in holiday, IN day not sunday, IN day not saturday
                                            * there are no NOT hours in this
                                            */

                                            if ((!in_array($a->ind, $holidays) and $a->weekday!=6) and $a->weekday!=5)
                                            {
                                                if ($in_date_seconds > $day_second)
                                                {
                                                    $day_diff = ($in_date_seconds - $day_second);
                                                    $ot_hours = $ot_hours + $day_diff;
                                                }
                                            }

                                            /*
                                             * when IN day not in holiday, IN day not sunday, IN day saturday */
                                            else if ((!in_array($a->ind, $holidays) and $a->weekday!=6) and $a->weekday==5)
                                            {
                                                if ($in_date_seconds > $saturday_second)
                                                {
                                                    $day_diff = ($in_date_seconds - $saturday_second);
                                                    $day_diff = ($day_diff > 11*60*60)?11*60*60:$day_diff;
                                                    $ot_hours = $ot_hours + $day_diff;
                                                }
                                            }
                                        }

                                    }
                                }
                                else
                                {

                                }
                        }
                        else
                        {
                            if($a->OUTDATE!='0000-00-00')
                            {
                                /*When IN day holiday, IN day saturday
                                This does not apply normal OT

                                if(in_array($a->ind, $holidays) and $a->weekday==5)
                                {
                                    if ($in_date_seconds > $day_second)
                                    {
                                        $day_diff = ($in_date_seconds - $day_second);
                                        $ot_hours = $ot_hours + $day_diff;

                                    }
                                }

                                */

                                /*When IN day holiday, IN day not saturday
                                this not apply normal OT
                                if(in_array($a->ind, $holidays) and $a->weekday!=5)
                                {

                                }
                                */

                                /*When IN day not holiday, IN day saturday*/
                                if(!in_array($a->ind, $holidays) and $a->weekday==5)
                                {
                                    if ($normal_in_date_seconds_day > $saturday_second)
                                    {
                                        $day_diff = ($normal_in_date_seconds_day - $saturday_second);
                                        $ot_hours = $ot_hours + $day_diff;
                                    }
                                }

                                else if(!in_array($a->ind, $holidays) and $a->weekday!=5)
                                {
                                    if ($normal_in_date_seconds_day > $day_second)
                                    {
                                        $day_diff = ($normal_in_date_seconds_day - $day_second);
                                        $ot_hours = $ot_hours + $day_diff;
                                    }
                                }

                            }
                        }
                    }

                    if(in_array("DOT", $code))
                    {
                        if($hours==0)
                        {
                            $in_month = date('Y-m',strtotime($a->DATE));
                            $out_month = date('Y-m',strtotime($a->OUTDATE));

                            if($in_month==$out_month){
                                
                                //In and Out Days are holidays
                                if (in_array($a->ind, $holidays) and in_array($a->outd, $holidays))
                                {
                                    $dot_hours = $dot_hours + $in_date_seconds;
                                    $out_date_seconds = ($out_date_seconds > $day_second)?$day_second:$out_date_seconds;
                                    $dot_hours = $dot_hours + $out_date_seconds;
                                }

                                else if(in_array($a->ind, $holidays) and !in_array($a->outd, $holidays))
                                {
                                    $dot_hours = $dot_hours + $in_date_seconds;
                                }
                                else if(!in_array($a->ind, $holidays) and in_array($a->outd, $holidays))
                                {
                                    $out_date_seconds = ($out_date_seconds > $day_second)?$day_second:$out_date_seconds;
                                    $dot_hours = $dot_hours + $out_date_seconds;
                                }




                            }else{

                                if(strtotime($in_month) < strtotime($month))
                                {
                                    /*
                                    *Out Days are holidays
                                    */
                                     if(in_array($a->outd, $holidays))
                                     {
                                         $dot_hours = $dot_hours + $out_date_seconds;
                                     }
                                    /*
                                     * when OUT day not in holiday, OUT day sunday */
                                    else if (!in_array($a->outd, $holidays) and $a->outweekday==6)
                                    {
                                        $dot_hours = $dot_hours + $out_date_seconds;
                                    }

                                }
                                else
                                {
                                    /*
                                    *IN Days are holidays
                                    */
                                    if(in_array($a->ind, $holidays))
                                    {
                                        $dot_hours = $dot_hours + $in_date_seconds;
                                    }
                                    /*
                                     * when IN day not in holiday, OUT day sunday */
                                    else if (!in_array($a->ind, $holidays) and $a->weekday==6)
                                    {
                                        $dot_hours = $dot_hours + $in_date_seconds;
                                    }

                                }
                            }

                        }
                        else
                        {
                            if($a->OUTDATE!='0000-00-00')
                            {
                                //When IN day holiday
                                if(in_array($a->ind, $holidays))
                                {
                                    /*if ($normal_in_date_seconds > $hours_second)
                                    {
                                        $dot_hours = $ot_hours + $normal_in_date_seconds;
                                    }*/
                                    $dot_hours = $dot_hours + $normal_in_date_seconds_day;
                                }
                            }
                        }
                    }
                    $row = $a;
                    $row->NOT = $ot_hours;
                    $row->DOT = $dot_hours;
                    $r[] = $row;
                }
            }
            $return = $r;
        }
        else
        {
            foreach($employees as $employee)
            {
                $shift = $this->get_user_shift($employee->EmpNo);
                $r = array();
                if($shift)
                {
                    $time1 = new DateTime($shift->Shift_From);
                    $time2 = new DateTime($shift->Shift_To);
                    $hours = $this->attn->DateIntervalToSec($time2, $time1);
                    $comtabel = 60*60;
                    $outtime = ($shift->Shift_To == '00:00:00') ? '17:00:00' : $shift->Shift_To;
                    $attns = $this->get_all_attn_filter($employee->EmpNo,$month);
                    $day_second = 8*60*60;
                    $saturday_second = 5*60*60;
                    $hours_second = 1*60*60;
                    $s=1;
                    foreach($attns as $a)
                    {
                        $ot_hours = 0; //second
                        $dot_hours = 0; //second
                        $in_date_seconds = ($a->OTDiffInDay+1);
                        $out_date_seconds = $a->OTDiffOutDay;

                        if(in_array("NOT", $code))
                        {
                            if($hours==0)
                            {
                                if($a->OUTDATE !='0000-00-00')
                                {
                                    //when IN OUT day not in holiday and not sunday or saturday
                                    if (!in_array($a->ind, $holidays) and !in_array($a->outd, $holidays) and ($a->weekday!=5 and $a->outweekday!=6) and ($a->outweekday!=5))
                                    {
                                        if ($in_date_seconds > $day_second)
                                        {
                                            $day_diff = ($in_date_seconds - $day_second);
                                            $day_diff = ($day_diff > $day_second)?$day_second:$day_diff;
                                            $ot_hours = $ot_hours + $day_diff;
                                            /*if ($day_diff > $hours_second)
                                            {
                                                $ot_hours = $ot_hours + $day_diff;
                                            }*/
                                        }
                                    }

                                    //when IN and OUT days not in holiday and not saturday not sunday out saturday
                                    else if(!in_array($a->ind, $holidays) and !in_array($a->outd, $holidays) and ($a->weekday!=5 and $a->outweekday!=6) and $a->outweekday==5)
                                    {

                                        if ($in_date_seconds > $day_second)
                                        {
                                            $day_diff = ($in_date_seconds - $day_second);
                                            $day_diff = ($day_diff > $day_second)?$day_second:$day_diff;
                                            $ot_hours = $ot_hours + $day_diff;
                                            /*if ($day_diff > $hours_second)
                                            {
                                                $ot_hours = $ot_hours + $day_diff;
                                            }*/
                                        }

                                        if ($out_date_seconds > $saturday_second)
                                        {
                                            $day_diff = ($out_date_seconds - $saturday_second);
                                            $day_dff = ($day_diff > 3*60*60)?3*60*60:$day_diff;
                                            $ot_hours = $ot_hours + $day_dff;
                                            /*if ($day_diff > $hours_second)
                                            {
                                            $day_dff = (floor($day_diff / 3600)> 3)?3:floor($day_diff / 3600);
                                            $ot_hours = $ot_hours + $day_dff;
                                            }
                                            */
                                        }

                                    }

                                    //when IN OUT days not in holiday and not sunday and in saturday
                                    else if((!in_array($a->ind, $holidays)) and $a->weekday==5)
                                    {
                                        if ($in_date_seconds > $saturday_second)
                                        {
                                            $day_diff = ($in_date_seconds - $saturday_second);
                                            $day_diff = ($day_diff > 11*60*60)?11*60*60:$day_diff;
                                            $ot_hours = $ot_hours + $day_diff;
                                            /*if ($day_diff > $hours_second)
                                            {
                                                $ot_hours = $ot_hours + $day_diff;
                                            }*/
                                        }
                                    }
                                }

                                //echo $dot_hours.'<br/>';
                            }
                            else
                            {
                                if($a->OUTDATE!='0000-00-00')
                                {
                                    if (!in_array($a->ind, $holidays))
                                    {
                                        if($a->weekday==5)
                                        {
                                            $d = $this->attn->DateIntervalToSec(new DateTime($a->OUTDATE.' '.$a->OUTTIME), new DateTime($a->DATE.' '.$shift->Shift_From));
                                            if($d > 18000)
                                            {
                                                $deff_second = ($d-18000);
                                                $ot_hours = $ot_hours + (($deff_second ) > $comtabel) ?$deff_second:0;
                                            }
                                        }
                                        else
                                        {
                                            if($comtabel < $a->diff){
                                                $ot_hours = ($ot_hours + $a->diff);
                                            }
                                        }
                                    }
                                    else
                                    {
                                        //echo '<br/>----',$a->diff,'<br/>';
                                    }

                                }
                            }
                        }

                        if(in_array("DOT", $code))
                        {
                            if($hours==0)
                            {
                                //In and Out Days are holidays
                                if (in_array($a->ind, $holidays) and in_array($a->outd, $holidays))
                                {
                                    $dot_hours = $dot_hours + $in_date_seconds;
                                    $out_date_seconds = ($out_date_seconds > $day_second)?$day_second:$out_date_seconds;
                                    $dot_hours = $ot_hours + $out_date_seconds;
                                }

                                else if(in_array($a->ind, $holidays) and !in_array($a->outd, $holidays))
                                {
                                    $dot_hours = $dot_hours + $in_date_seconds;
                                }
                                else if(!in_array($a->ind, $holidays) and in_array($a->outd, $holidays))
                                {
                                    $out_date_seconds = ($out_date_seconds > $day_second)?$day_second:$out_date_seconds;
                                    $dot_hours = $dot_hours + $out_date_seconds;
                                }

                            }
                            else
                            {
                                if($a->OUTDATE!='0000-00-00') {
                                    $d = $this->attn->DateIntervalToSec(new DateTime($a->OUTDATE . ' ' . $a->OUTTIME), new DateTime($a->DATE . ' ' . $shift->Shift_From));
                                    //echo $a->DATE.'------'.$d.'<br/>';
                                    if (!in_array($a->ind, $holidays)) {
                                        if ($a->weekday == 6) {
                                            $ot_hours = $ot_hours + $d;
                                        }
                                    } else {
                                        $ot_hours = $ot_hours + $d;

                                    }
                                }
                            }
                        }

                        $row = $a;
                        $row->NOT = $ot_hours;
                        $row->DOT = $dot_hours;
                        $r[] = $row;
                    }
                }
                $return[] = $r;
            }
            $rows = array();
            foreach($return AS $row)
            {
                foreach($row AS $v)
                {
                    $rows[] = $v;
                }
            }
            $return = $rows;
        }
        return $return;
    }

    function get_all_attn_filter($EmpNo, $month)
    {
        /*$sql = "SELECT A.ID,A.DEVICE,A.Comp, A.USER AS USER,
E.EmpName AS NAME,A.DATE,INTIME,A.OUTTIME,A.OUTDATE,DATE_FORMAT(A.DATE,'%d') AS ind,DATE_FORMAT(A.OUTDATE,'%d') AS outd,
		IF(S.Hours > 8,1,0) AS SHIFT,
		IF(
			TIME_TO_SEC(TIMEDIFF(CONCAT(A.OUTDATE,' ',A.OUTTIME),CONCAT(A.DATE,' ',H.Shift_From))) > 0,
			TIME_TO_SEC(TIMEDIFF(CONCAT(A.OUTDATE,' ',A.OUTTIME),CONCAT(A.DATE,' ',H.Shift_From))),
			'0'
		) AS diff,
		TIME_TO_SEC(TIMEDIFF(CONCAT(A.OUTDATE,' ',A.OUTTIME),CONCAT(A.DATE,' ',H.Shift_From))) AS DayShift,
		TIME_TO_SEC(TIMEDIFF(CONCAT(A.DATE,' ','23:59:59'),CONCAT(A.DATE,' ',A.INTIME))) AS OTDiffInDay,
		TIME_TO_SEC(TIMEDIFF(CONCAT(A.OUTDATE,' ',A.OUTTIME),CONCAT(A.OUTDATE,' ','00:00:00'))) AS OTDiffOutDay,
		WEEKDAY(A.DATE) AS weekday,
		WEEKDAY(A.OUTDATE) AS outweekday
FROM attendance AS A LEFT JOIN employee AS E ON (A.USER=E.EmpNo AND A.Comp=E.Comp)
LEFT JOIN shift_transaction AS S ON (A.Comp=S.Comp_Id AND E.EmpNo=S.EmpNo)
LEFT JOIN shift AS H ON (A.Comp=H.Comp_Id AND S.Shift_code=H.shift_code)
WHERE
A.USER ='" . $EmpNo . "' AND A.Comp = '" . $comp . "' AND (DATE_FORMAT(A.DATE,'%Y-%m')= '" . $month . "' OR DATE_FORMAT(A.OUTDATE,'%Y-%m')= '" . $month . "') AND E.Active='1' ORDER BY A.DATE,A.INTIME,A.NAME,A.USER ASC";
        $query = $this->db->query($sql);*/



        $sql = "SELECT A.ID,A.DEVICE,A.Comp, A.USER AS USER,
E.EmpName AS NAME,A.DATE,INTIME,A.OUTTIME,A.OUTDATE,DATE_FORMAT(A.DATE,'%d') AS ind,DATE_FORMAT(A.OUTDATE,'%d') AS outd,
		IF(S.Hours > 8,1,0) AS SHIFT,
		IF(
			TIME_TO_SEC(TIMEDIFF(CONCAT(A.OUTDATE,' ',A.OUTTIME),CONCAT(A.DATE,' ',H.Shift_From))) > 0,
			TIME_TO_SEC(TIMEDIFF(CONCAT(A.OUTDATE,' ',A.OUTTIME),CONCAT(A.DATE,' ',H.Shift_From))),
			'0'
		) AS diff, 
		TIME_TO_SEC(TIMEDIFF(CONCAT(A.OUTDATE,' ',A.OUTTIME),CONCAT(A.DATE,' ',A.INTIME))) AS DayShift,
		TIME_TO_SEC(TIMEDIFF(CONCAT(A.DATE,' ','23:59:59'),CONCAT(A.DATE,' ',A.INTIME))) AS OTDiffInDay,
		TIME_TO_SEC(TIMEDIFF(CONCAT(A.OUTDATE,' ',A.OUTTIME),CONCAT(A.OUTDATE,' ','00:00:00'))) AS OTDiffOutDay,
		WEEKDAY(A.DATE) AS weekday,
		WEEKDAY(A.OUTDATE) AS outweekday
FROM attendance AS A LEFT JOIN employee AS E ON (A.USER=E.EmpNo)
LEFT JOIN shift_transaction AS S ON (E.EmpNo=S.EmpNo)
LEFT JOIN shift AS H ON (S.Shift_code=H.shift_code)
WHERE
A.USER ='" . $EmpNo . "' AND (DATE_FORMAT(A.DATE,'%Y-%m')= '" . $month . "' OR DATE_FORMAT(A.OUTDATE,'%Y-%m')= '" . $month . "') AND E.Active='1' ORDER BY A.DATE,A.INTIME,A.NAME,A.USER ASC";
        $query = $this->db->query($sql);
        //echo $this->db->last_query();
        return $query->result();
    }

    function get_month_completed_attn($emp,$month)
    {
        $this->db->select('*');
        $this->db->from("attn_completed");
        //$this->db->where('Comp', $comp);
        $this->db->where('USER', $emp);
        $this->db->like ('DATE', $month,'both');
        $query = $this->db->get();
        return $query->result();
    }

    function get_month_completed_attn_by_code($emp,$month,$code='OT')
    {
        $this->db->select("SUM(".$code.") AS OT");
        $this->db->from("attn_completed");
        //$this->db->where('Comp', $comp);
        $this->db->where('USER', $emp);
        $this->db->like('DATE', $month,'both');
        $q = $this->db->get();
        if ($q->num_rows() == 1) {
            $ot = $q->row()->OT;
            return ($ot)?$ot:0;
        } else {
            return 0;
        }
    }

    function exist_rows($where)
    {
        $this->db->from($this->tableName);
        $this->db->where($where);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    function count_all($id = 0)
    {
        $this->db->from($this->tableName);
        if ($id != 0) {
            $this->db->where('Code', $id);
        }
        return $this->db->count_all_results();
    }

    function get_all()
    {
        $this->db->select('t.*, jt.EmpName');
        $this->db->from($this->tableName . " AS t");
        $this->db->join($this->join . ' AS jt', 't.EmpNo = jt.EmpNo', 'left');
        $this->db->where('t.Comp', $this->_getComp());
        $this->db->where('jt.Active', 1);
        $query = $this->db->get();
        return $query->result();
    }

    function get_all_month($where)
    {
        $this->db->trans_start();
        $this->db->select('t.*,t.EmpNo as EId, jt.EmpName');
        $this->db->from($this->tableName . " AS t");
        $this->db->join($this->join . ' AS jt', 't.EmpNo = jt.EmpNo', 'left');
        //$this->db->where('t.Comp',$this->_getComp());
        $this->db->where($where);
        $this->db->where('jt.Active', 1);
        $query = $this->db->get();
        $this->db->trans_complete();
        $result = $query->result();
        //echo $this->db->last_query(); die();
        return $result;


        if(count($rsult) > 0){
            $this->load->model('employee_model');
            $empls = $this->employee_model->get_all_filter();
            foreach ($empls as $emp) {
                $emp->month = $rsult['0']['month'];
                $emp->Id_Item = $rsult['0']['Id_Item'];
                $emp->Id = $rsult['0']['Id_Item'];
                $rr = $this->_search($rsult, 'EmpNo', $emp->EId);
                if (is_array($rr) and !empty($rr)) {
                    $emp->Rate = $rr['0']['Rate'];
                    $emp->Amount = $rsult['0']['Amount'];
                } else {
                    $emp->Rate = 0;
                    $emp->Amount = 0;
                }
            }
            $this->attn->p($empls); die();
            return $empls;
        }

        return false;
    }

    function get_all_month_by_employee($month,$emp)
    {
        $where = array('month' => $month,'EmpNo'=>$emp);
        $this->db->select('*,Id_Item as Id');
        $this->db->from($this->tableName);
        $this->db->where($where);
        $query = $this->db->get();
        $results = $query->result();
        //echo $this->db->last_query();
        return $results;
    }

    private function _search($array, $key, $value)
    {
        $results = array();

        if (is_array($array)) {
            if (isset($array[$key]) && $array[$key] == $value)
                $results[] = $array;
            foreach ($array as $subarray)
                $results = array_merge($results, $this->_search($subarray, $key, $value));
        }
        return $results;
    }

    function get_info($company_id = '')
    {
        $this->db->select('*');
        $this->db->from($this->tableName);
        $this->db->where('Dep_code', $company_id);
        $this->db->where('Status', 1);
        $this->db->where('Comp_Id', $this->_getComp());
        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            return $query->row();
        } else {
            return false;
        }
    }

    function save(&$data)
    {
        foreach ($data as $d) {
            $where = array('month' => $d['month'],'Id_Item' => $d['Id_Item'], 'Item_Code' => $d['Item_Code'], 'EmpNo' => $d['EmpNo'], 'Comp' => $d['Comp']);
            $this->db->where($where);
            if($this->db->delete($this->tableName)){
                $this->db->insert($this->tableName, $d);
            }


            /*if (!$this->exist_row($where)) {
                $this->db->insert($this->tableName, $d);
            } else {
                echo 'sadsf';
                $this->db->where($where);
                $this->db->update($this->tableName, $d);
            }*/
        }
        return true;
    }


    function exist_row($where)
    {
        $this->db->from($this->tableName);
        $this->db->where($where);
        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            return true;
        } else {
            return false;
        }
    }
    /*
    Deletes one
    */
    function delete($id)
    {
        if ($this->delete_image($id)) {
            $this->db->where('Code', $id);
            $this->db->where('Comp_Id', $this->_getComp());
            return $this->db->delete($this->tableName);
        }
        return false;
    }

    public function change_status($company_code)
    {
        $this->db->trans_start();
        $this->db->from('employee');
        $this->db->where('Comp', $this->_getComp());
        $this->db->where('Dep_code', $company_code);
        $this->db->where('Active', 1);
        $count = $this->db->count_all_results();
        $this->db->trans_complete();
        if ($count == 0) {
            $this->db->trans_start();
            $this->db->where('Dep_code', $company_code);
            $this->db->where('Comp_Id', $this->_getComp());
            $this->db->update($this->tableName, array('Status' => 0));
            //return $this->db->affected_rows();
            $return = (bool)($this->db->affected_rows() > 0);
            $this->db->trans_complete();
            return $return;
        } else {
            $this->messages->add($this->lang->line('error_company_delete'), "error");
            return false;
        }
    }

    public function get_holidays($month)
    {
        $this->db->select("DATE_FORMAT(date,'%d') AS newdate")
            ->from("calendar")
            ->where("DATE_FORMAT(date,'%Y-%m')", $month);
        $query = $this->db->get();
        //echo $this->db->last_query(); die();
        $data = array();
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row->newdate;
            }
        }
        return $data;
    }

    public function get_holiday_details($month)
    {
        $this->db->select("date,data")
            ->from("calendar")
            //->where("Comp", $comp)
            ->where("DATE_FORMAT(date,'%Y-%m')", $month);
        $query = $this->db->get();
        //echo $this->db->last_query(); die();
        $data = array();
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[$row->date] = $row;
            }
        }
        return $data;
    }

    public function get_tot($month)
    {
        $this->db->select("DATE_FORMAT(date,'%d') AS newdate")
            ->from("calendar")
            ->where("Type", 'TOT')
            ->where("DATE_FORMAT(date,'%Y-%m')", $month);
        $query = $this->db->get();
        //echo $this->db->last_query(); die();
        $data = array();
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row->newdate;
            }
        }
        return $data;
    }

    public function get_not($month)
    {
        $this->db->select("DATE_FORMAT(date,'%d') AS newdate")
            ->from("calendar")
            ->where("Type", 'NOT')
            ->where("DATE_FORMAT(date,'%Y-%m')", $month);
        $query = $this->db->get();
        //echo $this->db->last_query(); die();
        $data = array();
        if ($query->num_rows() > 0) {
            foreach ($query->result() as $row) {
                $data[] = $row->newdate;
            }
        }
        return $data;
    }



    function exist($where = array())
    {
        $this->db->from($this->tableName);
        $this->db->where($where);
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
            //$this->messages->add('', "error");
            return true;
        }
        else
        {
            return false;
        }
    }

    public function getCustomTran($empno,$month,$code){
        $this->db->from('custom_transaction');
        $this->db->where('EmpNo',$empno);
        //$this->db->where('Comp',$comp);
        $this->db->where('Month',$month);
        $this->db->where('Code',$code);
        $query = $this->db->get();
        if($query->num_rows()==1)
        {
            return $query->row();
        }
        return false;
    }

    function get_employee_custom_transactions($month='',$EmpNo='')
    {
        $this->db->select('Code,Amount');
        $this->db->from("custom_transaction");
        //if($comp != '') $this->db->where('Comp',$comp);
        if($month != '') $this->db->where('Month',$month);
        if($EmpNo != '') $this->db->where('EmpNo',$EmpNo);
        $q = $this->db->get();
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[$row->Code] = $row->Amount;
            }
            return $data;
        }
    }

    function get_employee_month_nopay($month='',$EmpNo='')
    {
        $this->db->select('Rate');
        $this->db->from("trans");
        //if($comp != '') $this->db->where('Comp',$comp);
        if($month != '') $this->db->where('Month',$month);
        if($EmpNo != '') $this->db->where('EmpNo',$EmpNo);
        $this->db->where('Id_Item','N');
        $this->db->where('Item_Code','NP');
        $q = $this->db->get();
        if ($q->num_rows() == 1) {

            return $q->row()->Rate;
        }
        return false;
    }

    public function deleteMeal($emp,$month,$code){
        $this->db->where('EmpNo',$emp);
        //$this->db->where('Comp',$comp);
        $this->db->where('Month',$month);
        $this->db->where('Code',$code);
        if($this->db->delete('custom_transaction'))
        {
            return true;
        }
        return false;
    }

    public function addCustomTrans($data = array())
    {
        //echo '<pre>',print_r($data); die();
        foreach ($data as $row) {
            $this->db->from('custom_transaction');
            $this->db->where('EmpNo',$row['EmpNo']);
            $this->db->where('Comp',$row['Comp']);
            $this->db->where('Code',$row['Code']);
            $this->db->where('Month',$row['Month']);
            $query = $this->db->get();
            if($query->num_rows()==1)
            {
                $this->db->where('EmpNo',$row['EmpNo']);
                $this->db->where('Comp',$row['Comp']);
                $this->db->where('Code',$row['Code']);
                $this->db->where('Month',$row['Month']);
                $this->db->update('custom_transaction', array('Amount'=>$row['Amount']));
            }
            else
            {
                $this->db->insert('custom_transaction', $row);
            }
        }
        return true;
    }


    function get_all_filter_sql($manth = '', $code = 'NOT')
    {
        $this->db->trans_start();
        $data = array();
        $this->db->select('t.EmpNo,t.Comp,t.EmpName, jt.Name');
        $this->db->from("employee AS t");
        $this->db->join('comp AS jt', 't.Comp = jt.Code', 'left');
        //if ($comp != '') $this->db->where('t.Comp', $comp);
        $this->db->where('t.Active', 1);
        $query = $this->db->get();
        foreach ($query->result() AS $row) {
            $shift = $this->get_user_shift($row->EmpNo);
            if ($shift) {
                $time1 = new DateTime($shift->Shift_From);
                $time2 = new DateTime($shift->Shift_To);
                $hours = $this->attn->DateIntervalToSec($time2, $time1);
                $comtabel = 60;
                $outtime = ($shift->Shift_To == '00:00:00') ? '17:00:00' : $shift->Shift_To;
                $user_query = (isset($row->EmpNo)) ? "(A.USER ='" . $row->EmpNo . "') " : null;
                $and = (isset($user_query)) ? "AND " : null;
                $date_query = '';
                if (!empty($manth)) {
                    $date_query = $and . " DATE_FORMAT(A.DATE,'%Y-%m')= '" . $manth . "' ";
                }
                $com_query = null;
                $condition = " WEEKDAY(A.DATE) NOT IN (5,6) ";
                switch ($code) {
                    case 'DOT':
                        $condition = " WEEKDAY(A.DATE) = 6 ";
                        break;
                    case 'NOT':

                        $condition = " (A.DATE=A.OUTDATE) AND (WEEKDAY(A.DATE) = 6) ";
                        break;
                    default:
                        $condition = " WEEKDAY(A.DATE) NOT IN (5,6) ";
                        break;
                }
                $sql = "SELECT
					ROUND(SUM(
					TIME_TO_SEC
					(
						IF(" . $condition . ",
							IF(
								TIME_TO_SEC
								(
									IF(
									TIME_TO_SEC(TIMEDIFF(A.OUTTIME,A.INTIME)) > '" . $hours . "',
									TIME_FORMAT( TIMEDIFF(A.OUTTIME,'" . $outtime . "') , '%H:%i' ),
									'00:00'
									)
								)> (" . $comtabel . ")*60,

								IF(
									TIME_TO_SEC(TIMEDIFF(A.OUTTIME,A.INTIME)) > '" . $hours . "',
									TIME_FORMAT( TIMEDIFF(A.OUTTIME,'" . $outtime . "') , '%H:%i' ),
									 '0'
								 ),
								 '0'
							),

							'0'
						)
					)
				 )/60/60,2) AS OT
				FROM employee AS E LEFT JOIN attendance AS A ON (A.USER=E.EmpNo AND A.Comp=E.Comp)
				WHERE " . $user_query . $date_query . " $com_query AND E.Active='1' ORDER BY A.DATE,A.INTIME,A.NAME,A.USER ASC";
                $query = $this->db->query($sql);
                $row->Rate = $query->row()->OT;
                $data[] = $row;
            }
        }
        $this->db->trans_complete();
        return $data;
    }

    public function get_user_shift($user_id)
    {
        $this->db->select('S.Shift_From,S.Shift_To,T.Hours');
        $this->db->from("shift AS S");
        $this->db->join("shift_transaction AS T", 'S.shift_code=T.Shift_code AND S.Comp_Id=T.Comp_Id', 'left');
        $this->db->where('T.EmpNo', $user_id);
        $query = $this->db->get();
        if ($query->num_rows() == 1) {
            return $query->row();
        } else {
            return false;
        }
    }

    public function monthly_fixed($month='')
    {
        $this->db->select('EmpNo');
        $this->db->from("employee");
        //$this->db->where('Comp',$comp);
        $this->db->where('Active',1);
        $q = $this->db->get();
        $records = array();
        $this->db->select('Id,Code,Amount,Rate');
        $this->db->from("items");
        //$this->db->where('Comp',$comp);
        $this->db->where('Fix','yes');
        $q2 = $this->db->get();
        $items = array();
        if ($q2->num_rows() > 0) {
            foreach (($q2->result()) as $row2) {
                $items[] = $row2;
                if ($q->num_rows() > 0) {
                    foreach (($q->result()) as $row) {
                        $record = array(
                            'month'=>$month,
                            'Id_Item'=>$row2->Id,
                            'Item_Code'=>$row2->Code,
                            'EmpNo'=>$row->EmpNo,
                            'Rate'=>$row2->Rate,
                            'Amount'=>$row2->Amount,
                        );
                        $records[] = $record;
                    }
                }
            }
        }
        //echo '<pre>',print_r($records); die();
        if($records){
            if($this->db->insert_ignore_batch('trans',$records))
            {
                return true;
            }
        }

        return false;
    }

    function get_month_half_days_employee_wise($month)
    {
        $this->db->select('EmpNo,LeaveFrom',FALSE);
        $this->db->from('leave_transaction');
        $this->db->where('LeaveType', 'Half');
        $this->db->where("DATE_FORMAT(`LeaveFrom`,'%Y-%m')='$month'");
        $this->db->order_by('EmpNo,LeaveFrom', 'asc');
        $q = $this->db->get();
        $emps = array();
        if ($q->num_rows() > 0) {
            $i = 0;
            $user = 0;
            foreach (($q->result()) as $row) {
                if($i==1){
                    $user = $row->EmpNo;
                    $emps[$user][] = $row->LeaveFrom;
                }else{
                    if($user == $row->EmpNo){
                        $emps[$user][] = $row->LeaveFrom;
                    }else{
                        $user = $row->EmpNo;
                        $emps[$user][] = $row->LeaveFrom;
                    }
                }
               $i++;
            }
        }
        return $emps;
    }
}
?>